// Glenn's POV-Ray Standard Objects File
// created 20-June-96
// last update 23-May-98
//
// Copyright 2005 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 

// This file is intended to be a generic collection of
// useful objects.  Especially good for testing scenes --
// reference a few of these objects and see how things look.

#declare TestSphere =
    sphere {
    <0,.5,0>, .5
    texture { pigment {color LightGrey } }
    finish {ambient 0 diffuse 0 metallic specular 0.80 roughness 1/120 reflection .99 }
  }
#declare WhiteSphere =
    sphere {
    <0,.5,0>, .5
    texture { pigment {color White } }
    finish {ambient .6 diffuse 0.7 specular 0.80 roughness 1/120 }
  }

// Table is defined with center of tabletop at <0,0,0>
// Legs extend 36 down
#declare TableTop =
   box {
     <-24,-1,-15>,<24,0,15>
        texture { GWood rotate y*90}
   }
#declare TableLeg =
   box {
     <-1,-36,-1>,<1,-1,1>
        texture { GWood rotate x*90}
   }
#declare Table =
   union {
     object { TableTop }
     object { TableLeg translate <-22.5,0,-13.5> }
     object { TableLeg translate <-22.5,0,13.5> }
     object { TableLeg translate <22.5,0,-13.5> }
     object { TableLeg translate <22.5,0,13.5> }

   }

#declare Jar =
  difference {
    merge {
      cylinder { // outside wall
        <0,.5,0>, <0,7.825,0>, 2
        texture { Glass3 }
      }
      sphere { // bottom
        <0,0,0>, 2
        scale <1,.16,1>
        translate <0,.5,0>
        texture { Glass3 }
      }
      torus { // top edge
        1.875, .125
        scale <1,1,1>
        translate <0,7.825,0>
        texture { Glass3 }
      }
    }
    cylinder { // inner space
      <0,.5,0>, <0,9,0>, 1.75
      texture { Glass3 }
    }
  }

// Paper Clip
#declare PaperClipWireDia = .05
#declare PCWR = PaperClipWireDia/2
#declare PaperClip =
  union {
    cylinder { <0,0,0>, <.8,0,0>, PCWR translate <-.3,0,.14> } //outer end
    cylinder { <0,0,0>, <1,0,0>, PCWR translate <-.5,0,-.14> }  //longest
    cylinder { <0,0,0>, <.8,0,0>, PCWR translate <-.5,0,.14-PCWR*2> }  //shorter
    cylinder { <0,0,0>, <.6,0,0>, PCWR translate <-.3,0,-.1> }  //inside end
    object {torus { .14, PCWR }
      clipped_by{plane{-x,0}}
      translate <.5,0,0>
    }
    object {torus { (.14+.14-PCWR*2)/2, PCWR }
      clipped_by{plane{x,0}}
      translate <-.5,0,-PCWR>
    }
    object {torus { (.14-PCWR*2+.1)/2, PCWR }
      clipped_by{plane{-x,0}}
      translate <.3,0,(.14-PCWR*2-.1)>
    }
    texture { pigment {color LightGrey } }
    finish {ambient 0 diffuse 0 metallic specular 0.80 roughness 1/120 reflection .99 }
    translate <0,PCWR,0>
  }

// A simple pad of paper 8.5 x 11
#declare LargePad =
   box {
     <0,0,0>,<11,.3,8.5>
     texture { PaperWhite }
   }
